/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.api.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.plusls.ommc.api.command.ClientCoordinates;
import com.plusls.ommc.api.command.ClientEntityAnchorArgument;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2277;
import net.minecraft.class_2278;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClientLocalCoordinates
implements ClientCoordinates {
    private final double left;
    private final double up;
    private final double forwards;

    public ClientLocalCoordinates(double left, double up, double forwards) {
        this.left = left;
        this.up = up;
        this.forwards = forwards;
    }

    @Override
    public class_243 getPosition(@NotNull FabricClientCommandSource commandSourceStack) {
        class_241 rotation = commandSourceStack.getRotation();
        class_243 pos = ClientEntityAnchorArgument.Anchor.FEET.apply(commandSourceStack);
        float f = class_3532.method_15362((float)((rotation.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float g = class_3532.method_15374((float)((rotation.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(-rotation.field_1343 * ((float)Math.PI / 180)));
        float i = class_3532.method_15374((float)(-rotation.field_1343 * ((float)Math.PI / 180)));
        float j = class_3532.method_15362((float)((-rotation.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)((-rotation.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        class_243 vec32 = new class_243((double)(f * h), (double)i, (double)(g * h));
        class_243 vec33 = new class_243((double)(f * j), (double)k, (double)(g * j));
        class_243 vec34 = vec32.method_1036(vec33).method_1021(-1.0);
        double d = vec32.field_1352 * this.forwards + vec33.field_1352 * this.up + vec34.field_1352 * this.left;
        double e = vec32.field_1351 * this.forwards + vec33.field_1351 * this.up + vec34.field_1351 * this.left;
        double l = vec32.field_1350 * this.forwards + vec33.field_1350 * this.up + vec34.field_1350 * this.left;
        return new class_243(pos.field_1352 + d, pos.field_1351 + e, pos.field_1350 + l);
    }

    @Override
    public class_241 getRotation(FabricClientCommandSource commandSourceStack) {
        return class_241.field_1340;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ClientLocalCoordinates parse(@NotNull StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        double d = ClientLocalCoordinates.readDouble(stringReader, i);
        if (stringReader.canRead() && stringReader.peek() == ' ') {
            stringReader.skip();
            double e = ClientLocalCoordinates.readDouble(stringReader, i);
            if (stringReader.canRead() && stringReader.peek() == ' ') {
                stringReader.skip();
                double f = ClientLocalCoordinates.readDouble(stringReader, i);
                return new ClientLocalCoordinates(d, e, f);
            }
            stringReader.setCursor(i);
            throw class_2277.field_10755.createWithContext((ImmutableStringReader)stringReader);
        }
        stringReader.setCursor(i);
        throw class_2277.field_10755.createWithContext((ImmutableStringReader)stringReader);
    }

    private static double readDouble(@NotNull StringReader stringReader, int i) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw class_2278.field_10759.createWithContext((ImmutableStringReader)stringReader);
        }
        if (stringReader.peek() != '^') {
            stringReader.setCursor(i);
            throw class_2277.field_10757.createWithContext((ImmutableStringReader)stringReader);
        }
        stringReader.skip();
        return stringReader.canRead() && stringReader.peek() != ' ' ? stringReader.readDouble() : 0.0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClientLocalCoordinates)) {
            return false;
        }
        ClientLocalCoordinates clientLocalCoordinates = (ClientLocalCoordinates)object;
        return this.left == clientLocalCoordinates.left && this.up == clientLocalCoordinates.up && this.forwards == clientLocalCoordinates.forwards;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.up, this.forwards);
    }
}

