/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.api.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;

public class ClientEntityAnchorArgument
implements ArgumentType<Anchor> {
    private static final Collection<String> EXAMPLES = Arrays.asList("eyes", "feet");
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(object -> ComponentCompat.translatable((String)"argument.anchor.invalid", (Object[])new Object[]{object}));

    public static Anchor getAnchor(@NotNull CommandContext<FabricClientCommandSource> commandContext, String string) {
        return (Anchor)((Object)commandContext.getArgument(string, Anchor.class));
    }

    public static ClientEntityAnchorArgument anchor() {
        return new ClientEntityAnchorArgument();
    }

    public Anchor parse(StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        String string = stringReader.readUnquotedString();
        Anchor anchor = Anchor.getByName(string);
        if (anchor == null) {
            stringReader.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader, (Object)string);
        }
        return anchor;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_9265(Anchor.BY_NAME.keySet(), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static enum Anchor {
        FEET("feet", (vec3, entity) -> vec3),
        EYES("eyes", (vec3, entity) -> new class_243(vec3.field_1352, vec3.field_1351 + (double)entity.method_5751(), vec3.field_1350));

        static final Map<String, Anchor> BY_NAME;
        private final String name;
        private final BiFunction<class_243, class_1297, class_243> transform;

        private Anchor(String string2, BiFunction<class_243, class_1297, class_243> biFunction) {
            this.name = string2;
            this.transform = biFunction;
        }

        @Nullable
        public static Anchor getByName(String string) {
            return BY_NAME.get(string);
        }

        public class_243 apply(class_1297 entity) {
            return this.transform.apply(entity.method_19538(), entity);
        }

        public class_243 apply(@NotNull FabricClientCommandSource commandSourceStack) {
            class_1297 entity = commandSourceStack.getEntity();
            return entity == null ? commandSourceStack.getPosition() : this.transform.apply(commandSourceStack.getPosition(), entity);
        }

        static {
            BY_NAME = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
                for (Anchor anchor : Anchor.values()) {
                    hashMap.put(anchor.name, anchor);
                }
            });
        }
    }
}

